@extends('layouts.master')
@section('title',__('All Comments'))
@section('breadcum')
    <div class="breadcrumbbar">
        <h4 class="page-title">{{ __('Comments') }}</h4>
        <div class="breadcrumb-list">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="{{url('/admin')}}" title="{{ __('Dashboard') }}">{{ __('Dashboard') }}</a></li>
              <li class="breadcrumb-item active" aria-current="page">{{ __('Users') }}</li>
            </ol>
        </div>  
    </div>
@endsection
@section('maincontent')
<div class="contentbar"> 
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <button type="button" class="float-right btn btn-danger-rgba mr-2 " data-toggle="modal"
                    data-target="#bulk_delete" title="{{ __('Delete Selected') }}"><i class="feather icon-trash mr-2"></i> {{ __('Delete Selected') }} </button>      
                    <h5 class="card-title">{{ __('All Comments') }}</h5>                    
                </div> 
                <div class="card-body">
                    <div class="table-responsive">
                         <table id="commentTable" class="table table-borderd">
                            <thead>
                                <th> {{ __('#') }}</th>
                                <th> {{ __('Username') }}</th>
                                <th> {{ __('Movie/TV Series') }}</th>
                                <th> {{ __('Comments') }}</th>
                                <th> {{ __('Submited ON') }}</th>
                                <th> {{ __('Status') }}</th>
                                <th> {{ __('Action') }}</th>
                            </thead>
                            <tbody>                                
                            </tbody>
                            <div id="bulk_delete" class="delete-modal modal fade" role="dialog">
                                <div class="modal-dialog modal-sm">
                                    <!-- Modal content-->
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <button type="button" class="close"
                                                data-dismiss="modal" title="{{ __('Close') }}">&times;</button>
                                            <div class="delete-icon"></div>
                                        </div>
                                        <div class="modal-body text-center">
                                            <h4 class="modal-heading">{{__('Are You Sure ?')}}</h4>
                                            <p>{{__('Do you really want to delete selected item names here? This
                                                process
                                                cannot be undone.')}}</p>
                                        </div>
                                        <div class="modal-footer">
                                            {!! Form::open(['method' => 'POST', 'action' => 'AdminCommentController@bulk_delete', 'id' => 'bulk_delete_form']) !!}
                                                @method('POST')
                                                <button type="reset" class="btn btn-secondary translate-y-3" data-dismiss="modal">{{__('No')}}</button>
                                                <button type="submit" class="btn btn-primary">{{__('Yes')}}</button>
                                            {!! Form::close() !!}
                                        </div>
                                    </div>
                                </div>
                            </div>                        
                        </table>                  
                    </div>
                </div>
                <div id="commentModal" class="modal fade" role="dialog">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title">{{ __('Comment and Replies') }}</h4>
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <h5>{{ __('Full Comment') }}</h5>
                                <p id="fullComment"></p>
                                <h5>{{ __('Replies') }}</h5>
                                <div class="table-responsive">
                                    <table id="subcommentTable" class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>{{ __('#') }}</th>
                                                <th>{{ __('User Name') }}</th>
                                                <th>{{ __('Reply') }}</th>
                                                <th>{{ __('Submitted On') }}</th>
                                                <th>{{ __('Status') }}</th>
                                                <th>{{ __('Actions') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="bulk_delete_subcomment" class="delete-modal modal fade" role="dialog">
                    <div class="modal-dialog modal-sm">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" title="{{ __('Close') }}">&times;</button>
                                <div class="delete-icon"></div>
                            </div>
                            <div class="modal-body text-center">
                                <h4 class="modal-heading">{{__('Are You Sure ?')}}</h4>
                                <p>{{__('Do you really want to delete selected item names here? This process cannot be undone.')}}</p>
                            </div>
                            <div class="modal-footer">
                                {!! Form::open(['method' => 'POST', 'action' => 'AdminCommentController@sub_bulk_delete', 'id' => 'bulk_delete_form_subcomment']) !!}
                                    @method('POST')
                                    <button type="reset" class="btn btn-secondary translate-y-3" data-dismiss="modal">{{__('No')}}</button>
                                    <button type="submit" class="btn btn-danger">{{__('Yes')}}</button>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
@section('script')
<script>
  $(function(){
    $('#checkboxAll').on('change', function(){
      if($(this).prop("checked") == true){
        $('.material-checkbox-input').attr('checked', true);
      }
      else if($(this).prop("checked") == false){
        $('.material-checkbox-input').attr('checked', false);
      }
    });
  });
</script>
<script>
    $(function () {
    "use strict";
    jQuery.noConflict();
    var table, subTable;

    console.log('Initializing comment table...');

    // Initialize main comment table
    if ($.fn.dataTable.isDataTable('#commentTable')) {
        table = $('#commentTable').DataTable();
        console.log('Existing comment table found and initialized');
    }  else {
        table = $('#commentTable').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            autoWidth: false,
            scrollCollapse: true,
            ajax: {
                url: "{{ route('admin.comment.index') }}",
                error: function (xhr, error, thrown) {
                    console.error('Error loading comment data:', error, thrown);
                }
            },
            columns: [
                {data: 'checkbox', name: 'checkbox', orderable: false, searchable: false},
                {data: 'username', name: 'username'},
                {data: 'name', name: 'name'},
                {
                    data: 'comment',
                    name: 'comment',
                    render: function(data, type, row) {
                        return data; // The server now sends the formatted HTML
                    }
                },
                {data: 'created_at', name: 'created_at'},
                {data: 'status', name: 'status'},
                {data: 'action', name: 'action', searchable: false}
            ],
            dom : 'lBfrtip',
            buttons : [
                'csv','excel','pdf','print'
            ],
            drawCallback: function(settings) {
                console.log('Comment table draw complete');
            }
        });
        console.log('New comment table initialized');
    }

    // Event listener for comment buttons
    $('#commentTable').on('click', '.comment-btn', function(e) {
        e.preventDefault();
        var comment = decodeURIComponent($(this).data('comment'));
        var commentId = $(this).data('id');
        
        console.log('Comment button clicked. Comment ID:', commentId);
        console.log('Full comment:', comment);

        // Set the full comment in the modal
        $('#fullComment').text(comment);

        // Initialize or refresh subcomment table
        initOrRefreshSubcommentTable(commentId);

        $('#commentModal').modal('show');
    });

    function initOrRefreshSubcommentTable(commentId) {
    console.log('Initializing or refreshing subcomment table for comment ID:', commentId);
    
    if ($.fn.DataTable.isDataTable('#subcommentTable')) {
        console.log('Existing subcomment table found, destroying it');
        $('#subcommentTable').DataTable().destroy();
    }

    console.log('Initializing new subcomment table');
    subTable = $('#subcommentTable').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        autoWidth: false,
        scrollCollapse: true,
        ajax: {
            url: "{{ url('/admin/subcomments') }}",
            data: function (d) {
                d.comment_id = commentId;
            },
            error: function (xhr, error, thrown) {
                console.error('Error loading subcomment data:', error, thrown);
            }
        },
        columns: [
            {data: 'checkbox', name: 'checkbox', orderable: false, searchable: false},
            {data: 'username', name: 'username'},
            {data: 'reply', name: 'reply'},
            {data: 'created_at', name: 'created_at'},
            {data: 'status', name: 'status'},
            {data: 'action', name: 'action', searchable: false}
        ],
        dom: 'lBfrtip',
        buttons: ['csv', 'excel', 'pdf', 'print'],
        drawCallback: function(settings) {
            console.log('Subcomment table draw complete');
        }
    });
    }
    
    // Bulk delete for subcomments
    $('#bulk_delete_form_subcomment').on('submit', function(e) {
        e.preventDefault();
        var form = this;
        var checkedBoxes = $('#subcommentTable').find('input[name="checked[]"]:checked');
        console.log('Bulk delete submitted. Checked boxes:', checkedBoxes.length);
        if (checkedBoxes.length > 0) {
            $.ajax({
                url: $(form).attr('action'),
                method: $(form).attr('method'),
                data: $(form).serialize(),
                success: function(response) {
                    console.log('Bulk delete response:', response);
                    if (response.success) {
                        $('#bulk_delete_subcomment').modal('hide');
                        if (subTable) {
                            subTable.ajax.reload();
                        }
                        console.log('Bulk delete successful');
                    } else {
                        console.error('Bulk delete failed:', response);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Bulk delete error:', status, error);
                }
            });
        } else {
            console.warn('No items selected for bulk delete');
        }
    });

    // Quick status change for subcomments
    $(document).on('click', '.quick-status-subcomment', function() {
        var url = $(this).data('href');
        console.log('Quick status change clicked. URL:', url);
        $.ajax({
            url: url,
            type: 'GET',
            success: function(response) {
                console.log('Quick status change response:', response);
                if (response.success) {
                    if (subTable) {
                        subTable.ajax.reload();
                    }
                    console.log('Status changed successfully');
                } else {
                    console.error('Status change failed:', response);
                }
            },
            error: function(xhr, status, error) {
                console.error('Status change error:', status, error);
            }
        });
    });

    // Delete subcomment
    $(document).on('click', '.delete-subcomment', function(e) {
        e.preventDefault();
        var url = $(this).data('href');
        console.log('Delete subcomment clicked. URL:', url);
        if (confirm("{{ __('Are you sure you want to delete this subcomment?') }}")) {
            $.ajax({
                url: url,
                type: 'DELETE',
                data: {
                    '_token': "{{ csrf_token() }}"
                },
                success: function(response) {
                    console.log('Delete subcomment response:', response);
                    if (response.success) {
                        if (subTable) {
                            subTable.ajax.reload();
                        }
                        console.log('Subcomment deleted successfully');
                    } else {
                        console.error('Subcomment deletion failed:', response);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Subcomment deletion error:', status, error);
                }
            });
        } else {
            console.log('Subcomment deletion cancelled by user');
        }
    });
});
</script>
@endsection